/*
 * Decompiled with CFR 0.152.
 */
package langs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import langs.ShortKeyword;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LangsTask
extends Task {
    private String languages;
    private String inDir;
    private String outDir;
    private String srcDir;
    private String idealLang;
    private static Hashtable shortKeys = new Hashtable();
    private static Vector warnings = new Vector();
    private static char[] shortKeyElems = new char[]{'_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static int shortKeywordCounter = 0;
    private static final int PP_STATE_DIRECT_COPY = 1;
    private static final int PP_STATE_WAIT_FOR_COMMENT = 2;
    private static final int PP_STATE_SIMPLE_COMMENT = 3;
    private static final int PP_STATE_MULTILINE_COMMENT = 4;
    private static final int PP_STATE_WAIT_FOR_MLC_END = 5;
    private static final int PP_STATE_STRING = 6;

    static boolean isSpecialKey(String string) {
        return string.indexOf("error_") == 0 || string.indexOf("lang_") == 0;
    }

    static String[] readFile(String string) throws Exception {
        String string2;
        Vector<String> vector = new Vector<String>();
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string2 = bufferedReader.readLine()) != null) {
            vector.add(string2);
        }
        bufferedReader.close();
        inputStreamReader.close();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static String keyToShortKey(String string) {
        if (LangsTask.isSpecialKey(string)) {
            return string;
        }
        ShortKeyword shortKeyword = (ShortKeyword)shortKeys.get(string);
        if (shortKeyword != null) {
            return shortKeyword.getShortKeyword();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = shortKeywordCounter;
        do {
            stringBuffer.append(shortKeyElems[n % shortKeyElems.length]);
        } while ((n /= shortKeyElems.length) > 0);
        String string2 = stringBuffer.toString();
        shortKeys.put(string, new ShortKeyword(string2));
        ++shortKeywordCounter;
        return string2;
    }

    private static String[] devideToWords(String string) throws Exception {
        String[] stringArray = new String[2];
        try {
            stringArray[0] = string.substring(1, string.indexOf(34, 1));
            stringArray[1] = string.substring(string.indexOf(34, string.indexOf(34, 1) + 1) + 1, string.lastIndexOf(34));
        }
        catch (Exception exception) {
            throw new Exception();
        }
        return stringArray;
    }

    private static Vector readLangFile(String string) {
        Vector<String[]> vector = new Vector<String[]>();
        try {
            String string2;
            File file = new File(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '/') continue;
                StringBuffer stringBuffer = new StringBuffer();
                int n = string2.length();
                for (int i = 0; i < n; ++i) {
                    char c = string2.charAt(i);
                    String string3 = null;
                    if (c == '\\' && i != n - 1) {
                        char c2 = string2.charAt(i + 1);
                        if (c2 == 'n') {
                            string3 = "\n";
                        }
                        if (c2 == 'r') {
                            string3 = "\r";
                        }
                        if (c2 == 't') {
                            string3 = "\t";
                        }
                        if (c2 == '\"') {
                            string3 = "\"";
                        }
                    }
                    if (string3 != null) {
                        stringBuffer.append(string3);
                        ++i;
                        continue;
                    }
                    if (c < ' ') {
                        c = ' ';
                    }
                    stringBuffer.append(c);
                }
                try {
                    stringArray = LangsTask.devideToWords(stringBuffer.toString());
                }
                catch (Exception exception) {
                    throw new BuildException("Wrong lang line '" + string2 + "' in file '" + string + "'");
                }
                vector.addElement(stringArray);
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
        return vector;
    }

    private static void addKeysToSpecialKeys(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            LangsTask.keyToShortKey(stringArray[0]);
        }
    }

    private static void writeLngFile(Vector vector, String string, boolean bl) throws BuildException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            int n = vector.size();
            dataOutputStream.writeShort(n);
            for (int i = 0; i < n; ++i) {
                String[] stringArray = (String[])vector.elementAt(i);
                dataOutputStream.writeUTF(LangsTask.keyToShortKey(stringArray[0]));
                dataOutputStream.writeUTF(stringArray[1]);
            }
            dataOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private static String[] scanDir(File file, String string) {
        Vector<String> vector = new Vector<String>();
        File[] fileArray = new File(file, string).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile() && fileArray[i].getName().endsWith(".java")) {
                vector.add(file + string + File.separator + fileArray[i].getName());
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            vector.addAll(Arrays.asList(LangsTask.scanDir(file, string + File.separator + fileArray[i].getName())));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void correctToIdealLang(String string, Vector vector, Hashtable hashtable) {
        String string2;
        Object object;
        Hashtable hashtable2 = LangsTask.pairsToTable(vector);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (hashtable2.containsKey(object)) continue;
            string2 = (String)hashtable.get(object);
            hashtable2.put(object, string2);
            warnings.add(string + ".lang: missed \"" + object + "\" (" + string2 + ")");
        }
        object = hashtable2.keys();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            if (hashtable.containsKey(string2)) continue;
            warnings.add(string + ".lang: unnecessary \"" + string2 + "\"");
            hashtable2.remove(string2);
            object = hashtable2.keys();
        }
        object = hashtable2.keys();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            ShortKeyword shortKeyword = (ShortKeyword)shortKeys.get(string2);
            if (shortKeyword == null || shortKeyword.getUsed()) continue;
            warnings.add(string + ".lang: not present at sources \"" + string2 + "\"");
            hashtable2.remove(string2);
            object = hashtable2.keys();
        }
        vector.clear();
        object = hashtable2.keys();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            vector.add(new String[]{string2, (String)hashtable2.get(string2)});
        }
    }

    private static String replaceString(String string, String string2, String string3) {
        int n;
        while ((n = string.indexOf(string2)) != -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length(), string.length());
        }
        return string;
    }

    private static void replaceLangKeysInSources(String string) {
        try {
            Object object;
            Object object2;
            String string2 = LangsTask.readAndPrepareSrcFile(string);
            Enumeration enumeration = shortKeys.keys();
            while (enumeration.hasMoreElements()) {
                boolean bl;
                object2 = (String)enumeration.nextElement();
                object = (ShortKeyword)shortKeys.get(object2);
                String string3 = ((ShortKeyword)object).getShortKeyword();
                String string4 = "\"" + (String)object2 + "\"";
                boolean bl2 = bl = string2.indexOf(string4) != -1;
                if (bl) {
                    ((ShortKeyword)object).wasUsed();
                }
                string2 = LangsTask.replaceString(string2, string4, "\"" + string3 + "\"");
            }
            object2 = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            object = new BufferedWriter((Writer)object2);
            ((Writer)object).write(string2);
            ((BufferedWriter)object).newLine();
            ((BufferedWriter)object).close();
            ((OutputStreamWriter)object2).close();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    static String readAndPrepareSrcFile(String string) throws BuildException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        try {
            int n2;
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((n2 = bufferedReader.read()) != -1) {
                switch (n) {
                    case 1: {
                        if (n2 == 47) {
                            n = 2;
                            break;
                        }
                        if (n2 == 34) {
                            n = 6;
                            stringBuffer.append((char)n2);
                            break;
                        }
                        stringBuffer.append((char)n2);
                        break;
                    }
                    case 2: {
                        if (n2 == 42) {
                            n = 4;
                            break;
                        }
                        if (n2 == 47) {
                            n = 3;
                            break;
                        }
                        stringBuffer.append('/');
                        stringBuffer.append((char)n2);
                        n = 1;
                        break;
                    }
                    case 3: {
                        if (n2 != 13 && n2 != 10) break;
                        n = 1;
                        break;
                    }
                    case 4: {
                        if (n2 != 42) break;
                        n = 5;
                        break;
                    }
                    case 5: {
                        if (n2 == 47) {
                            n = 1;
                            break;
                        }
                        if (n2 == 42) {
                            n = 5;
                            break;
                        }
                        n = 4;
                        break;
                    }
                    case 6: {
                        stringBuffer.append((char)n2);
                        if (n2 != 34) break;
                        n = 1;
                    }
                }
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
        return stringBuffer.toString();
    }

    private static void showWarnings() {
        int n = warnings.size();
        if (n == 0) {
            return;
        }
        System.out.println("*** WARNINGS ***");
        for (int i = 0; i < n; ++i) {
            System.out.println((String)warnings.elementAt(i));
        }
        warnings.clear();
    }

    private static Hashtable pairsToTable(Vector vector) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            hashtable.put(stringArray[0], stringArray[1]);
        }
        return hashtable;
    }

    public void setLanguages(String string) {
        this.languages = string;
    }

    public void setInDir(String string) {
        this.inDir = string;
    }

    public void setOutDir(String string) {
        this.outDir = string;
    }

    public void setSrcDir(String string) {
        this.srcDir = string;
    }

    public void setIdealLang(String string) {
        this.idealLang = string;
    }

    public void execute() throws BuildException {
        int n;
        String[] stringArray;
        Vector vector;
        Object object;
        Hashtable hashtable = null;
        shortKeys.clear();
        warnings.clear();
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.languages, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            vector2.add(string);
        }
        int n2 = vector2.size();
        if (n2 == 0) {
            new BuildException("No language specified");
        }
        System.out.println("Loading lang file[s]... ");
        Vector vector3 = null;
        if (this.idealLang != null) {
            vector3 = LangsTask.readLangFile(this.inDir + "/" + this.idealLang + ".lang");
            hashtable = LangsTask.pairsToTable(vector3);
        }
        for (int i = 0; i < n2; ++i) {
            object = (String)vector2.elementAt(i);
            vector = LangsTask.readLangFile(this.inDir + "/" + (String)object + ".lang");
            LangsTask.addKeysToSpecialKeys(vector);
        }
        try {
            stringArray = new FileOutputStream(this.outDir + "/langlist.lng");
            object = new DataOutputStream((OutputStream)stringArray);
            ((DataOutputStream)object).writeShort(vector2.size());
            for (int i = 0; i < vector2.size(); ++i) {
                ((DataOutputStream)object).writeUTF((String)vector2.elementAt(i));
            }
            ((DataOutputStream)object).flush();
            stringArray.close();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
        LangsTask.showWarnings();
        System.out.println("Preprocessing java sources... ");
        stringArray = LangsTask.scanDir(new File(this.srcDir), "");
        for (n = 0; n < stringArray.length; ++n) {
            LangsTask.replaceLangKeysInSources(stringArray[n]);
        }
        System.out.println("Saving lng file[s]... ");
        n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            String string = (String)vector2.elementAt(n);
            vector = LangsTask.readLangFile(this.inDir + "/" + string + ".lang");
            LangsTask.correctToIdealLang(string, vector, hashtable);
            LangsTask.writeLngFile(vector, this.outDir + "/" + string + ".lng", n2 == 1);
        }
        LangsTask.showWarnings();
    }
}

