/*
 * Decompiled with CFR 0.152.
 */
package jimmLangFileTool;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jimmLangFileTool.JimmLangFileTool;
import jimmLangFileTool.LGFile;
import jimmLangFileTool.LGFileSubset;
import jimmLangFileTool.LGString;

public class GUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane compareScrollPane = null;
    private JTable compareTable = null;
    private JlftTableModel jlftTableModel = null;
    private TableCellRenderer renderer;
    private JimmLangFileTool jlft;
    private JToolBar compareToolBar = null;
    private JButton openBase = null;
    private JButton openCompare = null;
    private JButton saveCompare = null;
    private JButton remove = null;
    private JButton about = null;
    private JPanel legendPanel = null;
    private JLabel white = null;
    private JLabel yellow = null;
    private JLabel orange = null;
    private JLabel red = null;
    private JButton removeGroup = null;

    public GUI(JimmLangFileTool jimmLangFileTool) {
        this.jlft = jimmLangFileTool;
        this.setDefaultCloseOperation(3);
    }

    public void initialize() {
        this.renderer = new JlftTableRenderer();
        this.setContentPane(this.getJContentPane(false));
        this.setTitle("Jimm Lang File Tool");
        this.setSize(new Dimension(850, 500));
        this.setLocation(new Point(20, 20));
        this.fillInValues();
        this.pack();
        this.setVisible(true);
    }

    private int getSizeForTable() {
        int n = this.jlft.getBase().getEntrysize() > this.jlft.getCompare().getEntrysize() ? this.jlft.getBase().getEntrysize() : this.jlft.getCompare().getEntrysize();
        return n;
    }

    private void fillInValues() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.compareTable.removeAll();
        this.compareTable.setModel(this.getDefaultTableModel(true));
        this.setTableProps();
        for (n = 0; n < this.jlft.getBase().size(); ++n) {
            this.compareTable.setValueAt((LGFileSubset)this.jlft.getBase().get(n), n + n3 + n4, 0);
            for (n2 = 0; n2 < ((LGFileSubset)this.jlft.getBase().get(n)).size(); ++n2) {
                if (((LGString)((LGFileSubset)this.jlft.getBase().get(n)).get(n2)).getTranslated() != 4) {
                    this.compareTable.setValueAt(((LGFileSubset)this.jlft.getBase().get(n)).get(n2), n + n3 + n2 + 1 + n4, 0);
                    this.compareTable.setValueAt(((LGFileSubset)this.jlft.getBase().get(n)).get(n2), n + n3 + n2 + 1 + n4, 1);
                    continue;
                }
                --n4;
            }
            n3 += n2;
        }
        n3 = 0;
        n4 = 0;
        for (n = 0; n < this.jlft.getCompare().size(); ++n) {
            if (!((LGFileSubset)this.jlft.getCompare().get(n)).isRemoved()) {
                this.compareTable.setValueAt((LGFileSubset)this.jlft.getCompare().get(n), n + n3 + n4 + n5, 2);
                for (n2 = 0; n2 < ((LGFileSubset)this.jlft.getCompare().get(n)).size(); ++n2) {
                    if (((LGString)((LGFileSubset)this.jlft.getCompare().get(n)).get(n2)).getTranslated() != 4) {
                        this.compareTable.setValueAt(((LGFileSubset)this.jlft.getCompare().get(n)).get(n2), n + n3 + n2 + 1 + n4 + n5, 2);
                        this.compareTable.setValueAt(((LGFileSubset)this.jlft.getCompare().get(n)).get(n2), n + n3 + n2 + 1 + n4 + n5, 3);
                        continue;
                    }
                    --n4;
                }
                n3 += n2;
                continue;
            }
            --n5;
        }
    }

    private JPanel getJContentPane(boolean bl) {
        if (this.jContentPane == null || bl) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setPreferredSize(new Dimension(850, 500));
            this.jContentPane.setMinimumSize(new Dimension(810, 66));
            this.jContentPane.add((Component)this.getCompareToolBar(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getCompareScrollPane(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JScrollPane getCompareScrollPane() {
        if (this.compareScrollPane == null) {
            this.compareScrollPane = new JScrollPane();
            this.compareScrollPane.setName("compareScrollPane");
            this.compareScrollPane.setViewportView(this.getCompareTable());
        }
        return this.compareScrollPane;
    }

    private JTable getCompareTable() {
        if (this.compareTable == null) {
            this.compareTable = new JTable();
            this.compareTable.setBackground(Color.white);
            this.compareTable.setFont(new Font("DialogInput", 0, 12));
            this.compareTable.setSelectionMode(0);
            this.compareTable.setModel(this.getDefaultTableModel(false));
            this.setTableProps();
        }
        return this.compareTable;
    }

    public void setTableProps() {
        TableColumn tableColumn = this.compareTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(170);
        tableColumn.setMaxWidth(170);
        tableColumn.setPreferredWidth(170);
        tableColumn = this.compareTable.getColumnModel().getColumn(1);
        tableColumn.setMinWidth(220);
        tableColumn.setPreferredWidth(220);
        tableColumn = this.compareTable.getColumnModel().getColumn(2);
        tableColumn.setMinWidth(170);
        tableColumn.setMaxWidth(170);
        tableColumn.setPreferredWidth(170);
        tableColumn = this.compareTable.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(220);
        tableColumn.setPreferredWidth(220);
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font("DialogInput", 0, 12));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        try {
            this.compareTable.setDefaultEditor(Class.forName("java.lang.Object"), defaultCellEditor);
            this.compareTable.setDefaultRenderer(Class.forName("java.lang.Object"), this.renderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private DefaultTableModel getDefaultTableModel(boolean bl) {
        if (this.jlftTableModel == null || bl) {
            this.jlftTableModel = new JlftTableModel();
            Vector<String> vector = new Vector<String>();
            vector.add("Base key " + this.jlft.getBase().getName());
            vector.add("Base value " + this.jlft.getBase().getName());
            vector.add("Compare key " + this.jlft.getCompare().getName());
            vector.add("Compare value " + this.jlft.getCompare().getName());
            this.jlftTableModel.setColumnIdentifiers(vector);
            this.jlftTableModel.setColumnCount(4);
            this.jlftTableModel.setRowCount(this.getSizeForTable());
        }
        return this.jlftTableModel;
    }

    private JToolBar getCompareToolBar() {
        if (this.compareToolBar == null) {
            this.compareToolBar = new JToolBar();
            this.compareToolBar.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.compareToolBar.setFloatable(false);
            this.compareToolBar.setName("compareToolBar");
            this.compareToolBar.add(this.getOpenBase());
            this.compareToolBar.add(this.getOpenCompare());
            this.compareToolBar.add(this.getSaveCompare());
            this.compareToolBar.add(this.getRemove());
            this.compareToolBar.add(this.getRemoveGroup());
            this.compareToolBar.add(this.getAbout());
            this.compareToolBar.add(this.getLegendPanel());
        }
        return this.compareToolBar;
    }

    private JButton getOpenBase() {
        if (this.openBase == null) {
            this.openBase = new JButton();
            this.openBase.setText("Open base");
            this.openBase.setToolTipText("Open a base langauge file (the left one)");
            this.openBase.addActionListener(this);
        }
        return this.openBase;
    }

    private JButton getOpenCompare() {
        if (this.openCompare == null) {
            this.openCompare = new JButton();
            this.openCompare.setText("Open compare");
            this.openCompare.setToolTipText("Open a compare langauge file (the left one)");
            this.openCompare.addActionListener(this);
        }
        return this.openCompare;
    }

    private JButton getSaveCompare() {
        if (this.saveCompare == null) {
            this.saveCompare = new JButton();
            this.saveCompare.setText("Save compare");
            this.saveCompare.setToolTipText("Save the compare file (the right one)");
            this.saveCompare.addActionListener(this);
        }
        return this.saveCompare;
    }

    private JButton getRemove() {
        if (this.remove == null) {
            this.remove = new JButton();
            this.remove.setText("Remove");
            this.remove.setToolTipText("Remove the currently selected langauge String");
            this.remove.addActionListener(this);
        }
        return this.remove;
    }

    private JButton getAbout() {
        if (this.about == null) {
            this.about = new JButton();
            this.about.setText("About");
            this.about.setToolTipText("Display info about this application");
            this.about.addActionListener(this);
        }
        return this.about;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        int n;
        JFileChooser jFileChooser;
        int n2 = -1;
        if (actionEvent.getSource() == this.openBase) {
            jFileChooser = new JFileChooser("src/lng");
            n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                // empty if block
            }
            file = jFileChooser.getSelectedFile();
            try {
                this.jlft.setBase(LGFile.load(file.getCanonicalPath()));
            }
            catch (Exception exception) {
                System.out.println("Error loading file");
            }
            this.jlft.compare();
            this.fillInValues();
        }
        if (actionEvent.getSource() == this.openCompare) {
            jFileChooser = new JFileChooser("src/lng/");
            n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                // empty if block
            }
            file = jFileChooser.getSelectedFile();
            try {
                this.jlft.setCompare(LGFile.load(file.getCanonicalPath()));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error loading the file", "Error", 0);
            }
            this.jlft.compare();
            this.fillInValues();
        }
        if (actionEvent.getSource() == this.saveCompare) {
            jFileChooser = new JFileChooser("src/lng/");
            n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                // empty if block
            }
            file = jFileChooser.getSelectedFile();
            try {
                this.jlft.getCompare().save(file.getCanonicalPath());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error saving the file", "Error", 0);
            }
            this.jlft.compare();
            this.fillInValues();
        }
        if (actionEvent.getSource() == this.remove) {
            if (this.compareTable.getSelectedColumn() == -1 || this.compareTable.getSelectedRow() == -1) {
                JOptionPane.showMessageDialog(this, "You have to select an item first", "Select first", 0);
            } else if (this.compareTable.getValueAt(this.compareTable.getSelectedRow(), this.compareTable.getSelectedColumn()) instanceof LGString) {
                if (((LGString)this.compareTable.getValueAt(this.compareTable.getSelectedRow(), this.compareTable.getSelectedColumn())).isTranslated() != 3) {
                    JOptionPane.showMessageDialog(this, "You can only delete items which are not in the base file(red).", "Cannot delete item", 0);
                } else {
                    n2 = JOptionPane.showConfirmDialog(this, "Delete \"" + ((LGString)this.compareTable.getValueAt(this.compareTable.getSelectedRow(), this.compareTable.getSelectedColumn())).getKey() + "\"?", "Delete?", 0);
                    switch (n2) {
                        case 0: {
                            System.out.println("YES");
                            ((LGString)this.compareTable.getValueAt(this.compareTable.getSelectedRow(), this.compareTable.getSelectedColumn())).setTranslated(4);
                            this.fillInValues();
                            break;
                        }
                    }
                }
            }
        }
        if (actionEvent.getSource() == this.removeGroup && this.compareTable.getSelectedColumn() > 1) {
            if (this.compareTable.getSelectedColumn() == -1 || this.compareTable.getSelectedRow() == -1) {
                JOptionPane.showMessageDialog(this, "You have to select a group item first", "Select first", 0);
            } else if (this.compareTable.getValueAt(this.compareTable.getSelectedRow(), this.compareTable.getSelectedColumn()) instanceof LGFileSubset) {
                n2 = JOptionPane.showConfirmDialog(this, "Delete \"" + ((LGFileSubset)this.compareTable.getValueAt(this.compareTable.getSelectedRow(), this.compareTable.getSelectedColumn())).getId() + "\"?", "Delete?", 0);
                switch (n2) {
                    case 0: {
                        System.out.println("YES");
                        System.out.println("Delete it");
                        ((LGFileSubset)this.compareTable.getValueAt(this.compareTable.getSelectedRow(), this.compareTable.getSelectedColumn())).setRemoved(true);
                        this.fillInValues();
                        break;
                    }
                }
            }
        }
        if (actionEvent.getSource() == this.about) {
            JOptionPane.showMessageDialog(this, "Jimm Lang File Tool - Tool for editing Jimm language Files\n\n (C) Jimm project 2005\n\nwww.jimm.org\n\n", "About Jimm Lang File Tool", -1);
        }
    }

    private JPanel getLegendPanel() {
        if (this.legendPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(3);
            gridLayout.setVgap(3);
            gridLayout.setColumns(2);
            this.legendPanel = new JPanel();
            this.legendPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.legendPanel.setLayout(gridLayout);
            this.legendPanel.add((Component)this.getWhite(), null);
            this.legendPanel.add((Component)this.getRed(), null);
            this.legendPanel.add((Component)this.getOrange(), null);
            this.legendPanel.add((Component)this.getYellow(), null);
        }
        return this.legendPanel;
    }

    private JLabel getWhite() {
        if (this.white == null) {
            this.white = new JLabel();
            this.white.setText("Key was found in base and compare file");
            this.white.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.white.setFont(new Font("MS Sans Serif", 0, 10));
            this.white.setOpaque(true);
            this.white.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.white.setBackground(new Color(255, 255, 255));
        }
        return this.white;
    }

    private JLabel getYellow() {
        if (this.yellow == null) {
            this.yellow = new JLabel();
            this.yellow.setText("Key was not found in compare file");
            this.yellow.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.yellow.setFont(new Font("MS Sans Serif", 0, 10));
            this.yellow.setOpaque(true);
            this.yellow.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.yellow.setBackground(Color.yellow);
        }
        return this.yellow;
    }

    private JLabel getOrange() {
        if (this.orange == null) {
            this.orange = new JLabel();
            this.orange.setText("Text for this key was changed but not saved yet");
            this.orange.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.orange.setFont(new Font("MS Sans Serif", 0, 10));
            this.orange.setOpaque(true);
            this.orange.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.orange.setBackground(Color.orange);
        }
        return this.orange;
    }

    private JLabel getRed() {
        if (this.red == null) {
            this.red = new JLabel();
            this.red.setText("Key was found in compare but not in base");
            this.red.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.red.setFont(new Font("MS Sans Serif", 0, 10));
            this.red.setOpaque(true);
            this.red.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.red.setBackground(Color.red);
        }
        return this.red;
    }

    private JButton getRemoveGroup() {
        if (this.removeGroup == null) {
            this.removeGroup = new JButton();
            this.removeGroup.setText("Remove group");
            this.removeGroup.setToolTipText("Remove a whole group of Strings at once");
            this.removeGroup.addActionListener(this);
        }
        return this.removeGroup;
    }

    public class JlftTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        LGString lgs;

        public boolean isCellEditable(int n, int n2) {
            return super.getValueAt(n, n2) instanceof LGString && n2 >= 2 && ((LGString)super.getValueAt(n, n2)).isTranslated() != 3;
        }

        public Object getValueAt(int n, int n2) {
            if (super.getValueAt(n, n2) instanceof LGString) {
                this.lgs = (LGString)super.getValueAt(n, n2);
                if (n2 % 2 == 0) {
                    this.lgs.setReturnKey(true);
                } else {
                    this.lgs.setReturnKey(false);
                }
                return this.lgs;
            }
            return super.getValueAt(n, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof String && !((String)object).startsWith("MOD_") && !((String)object).startsWith("TAR_") && !((String)object).startsWith("GENERAL") && this.getValueAt(n, n2) instanceof LGString) {
                this.lgs = (LGString)this.getValueAt(n, n2);
                if (!((String)object).equals(this.lgs.getValue())) {
                    this.lgs.setTranslated(2);
                    this.lgs.setValue((String)object);
                    super.setValueAt(this.lgs.getClone(), n, n2);
                }
            } else {
                super.setValueAt(object, n, n2);
            }
        }
    }

    public class JlftTableRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        LGString lgs;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof LGString) {
                this.lgs = (LGString)object;
                switch (this.lgs.isTranslated()) {
                    case 0: {
                        component.setBackground(Color.white);
                        break;
                    }
                    case 2: {
                        component.setBackground(Color.orange);
                        break;
                    }
                    case 3: {
                        component.setBackground(Color.red);
                        break;
                    }
                    case 1: {
                        component.setBackground(Color.yellow);
                        break;
                    }
                    default: {
                        component.setBackground(Color.white);
                        break;
                    }
                }
            } else {
                component.setFocusable(false);
                component.setBackground(Color.lightGray);
            }
            return component;
        }
    }
}

